<?php

namespace App\Filament\Resources;

use Filament\Forms;
use Filament\Tables;
use App\Models\AboutApp;
use Filament\Forms\Form;
use Filament\Tables\Table;
use Filament\Resources\Resource;
use Filament\Forms\Components\Repeater;
use Illuminate\Database\Eloquent\Builder;
use App\Filament\Resources\AboutAppResource\Pages;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use App\Filament\Resources\AboutAppResource\RelationManagers;
use App\Tables\Columns\MapProfile;

class AboutAppResource extends Resource
{
    protected static ?string $model = AboutApp::class;

    protected static ?string $navigationIcon = 'heroicon-o-rectangle-stack';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('nama_singkat')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('nama_panjang')
                    ->required()
                    ->maxLength(255),
                Forms\Components\FileUpload::make('logo')
                    ->directory('logo'),
                Forms\Components\FileUpload::make('icon')
                    ->directory('icon'),
                Forms\Components\Textarea::make('alamat')
                    ->columnSpanFull(),
                Forms\Components\TextInput::make('telp')
                    ->tel()
                    ->maxLength(255),
                Forms\Components\TextInput::make('email')
                    ->email()
                    ->maxLength(255),
                Repeater::make('sosmed')
                    ->schema([
                        Forms\Components\TextInput::make('platform')
                            ->label('Platform (e.g., Facebook, Twitter)')
                            ->required(),
                        Forms\Components\TextInput::make('url')
                            ->label('URL')
                            ->url()
                            ->required(),
                    ])
                    ->reorderableWithButtons(),
                Forms\Components\Textarea::make('maps')
                    ->maxLength(555),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('nama_singkat')
                    ->searchable(),
                Tables\Columns\TextColumn::make('nama_panjang')
                    ->searchable(),
                Tables\Columns\ImageColumn::make('logo')
                    ->circular(),
                Tables\Columns\ImageColumn::make('icon')
                    ->circular(),
                Tables\Columns\TextColumn::make('telp')
                    ->searchable(),
                Tables\Columns\TextColumn::make('email')
                    ->searchable(),
                MapProfile::make('map')
                    ->label('Lokasi '),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    // Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListAboutApps::route('/'),
            // 'create' => Pages\CreateAboutApp::route('/create'),
            // 'edit' => Pages\EditAboutApp::route('/{record}/edit'),
        ];
    }
}
