<?php

namespace App\Filament\Resources;

use App\Filament\Resources\JenisKerjaResource\Pages;
use App\Filament\Resources\JenisKerjaResource\RelationManagers;
use App\Models\JenisKerja;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class JenisKerjaResource extends Resource
{
    protected static ?string $model = JenisKerja::class;

    protected static ?string $navigationIcon = 'heroicon-o-circle-stack';
    protected static ?string $navigationGroup = 'Data Master';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('bidang_id')
                    ->required()
                    ->searchable()
                    ->preload()
                    ->relationship('bidang', 'nama'),
                Forms\Components\RichEditor::make('uraian')
                    ->required()
                    ->columnSpanFull(),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(function () {
                return JenisKerja::orderBy('id', 'DESC');
            })
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('NO')
                    ->rowIndex()
                    ->searchable(),
                Tables\Columns\TextColumn::make('bidang.nama')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('uraian')
                    ->searchable()
                    ->html()
                    ->limit(30),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListJenisKerjas::route('/'),
            'create' => Pages\CreateJenisKerja::route('/create'),
            'edit' => Pages\EditJenisKerja::route('/{record}/edit'),
        ];
    }
}
