<?php

namespace App\Filament\Resources\UserResource\Pages;

use Filament\Actions;
use App\Exports\TemplateUserImport;
use Maatwebsite\Excel\Facades\Excel;
use App\Filament\Resources\UserResource;
use Filament\Resources\Pages\ListRecords;

class ListUsers extends ListRecords
{
    protected static string $resource = UserResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('downloadTemplate')
                ->label('Download Template Excel')
                ->icon('heroicon-o-arrow-down-on-square-stack')
                ->color('danger')
                ->action(function () {
                    // Mengunduh file template Excel dengan hanya headings
                    return Excel::download(new TemplateUserImport, 'template_user_import.xlsx');
                }),
            Actions\CreateAction::make(),
            \EightyNine\ExcelImport\ExcelImportAction::make(),
            // ->validateUsing([
            //     'bidang_id' => 'required',
            //     'name' => 'required',
            //     'username' => 'required|string|unique:users,username',
            //     'email' => 'required|email|unique:users,email',
            //     'password' => 'required', // Validation remains as required
            // ])->beforeImport(function ($validatedData) {

            //     if (empty($validatedData['password'])) {
            //         $validatedData['password'] = \Illuminate\Support\Facades\Hash::make('password');
            //     }

            //     return $validatedData;
            // }),
        ];
    }
}
