<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Absensi;
use App\Models\AboutApp;
use App\Models\JenisAbsen;
use App\Models\SetShift;
use App\Models\UraianJenisAbsen;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;

class AbsensiController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {

        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        //
        $data['title'] = "Rekapitulasi Absensi";
        $user = Auth::id();
        $data['dataUser'] = User::where('id', $user)
            ->first();
        $today = Carbon::now('Asia/Jakarta')->toDateString();
        $data['absenToday'] = Absensi::where('user_id', $user)
            ->whereDate('jam_datang', $today)
            ->first();

        $currentYear = Carbon::now()->year;

        $data['dataAbsensi'] = Absensi::where('user_id', $user)
            ->whereYear('created_at', $currentYear)
            ->get();

        // Rekapitulasi Absensi Tahunan
        // Ambil data absensi dalam tahun ini
        // Hitung jumlah masing-masing kategori dalam 1 tahun terakhir

        $data['hadir'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 1)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['cuti'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 2)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['izin'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 3)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['sakit'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 4)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['dinas_luar'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 5)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['pulang_cepat'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 6)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['alpa'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 7)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['terlambat'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 8)
            ->whereYear('created_at', $currentYear)
            ->count();
        // Rekapitulasi Absensi Tahunan

        // Ambil filter dari request
        $filterYear = $request->input('tahun', Carbon::now()->year);
        $filterMonth = $request->input('bulan', Carbon::now()->month);

        // Ambil data absensi berdasarkan filter bulan dan tahun
        $data['dataAbsensifilter'] = Absensi::where('user_id', $user)
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get();

        // Hitung jumlah masing-masing kategori dalam periode yang difilter
        $jenisAbsen = [
            'hadir' => 1,
            'cuti' => 2,
            'izin' => 3,
            'sakit' => 4,
            'dinas_luar' => 5,
            'pulang_cepat' => 6,
            'alpa' => 7,
            'terlambat' => 8,
        ];

        foreach ($jenisAbsen as $key => $id) {
            $data[$key] = Absensi::where('user_id', $user)
                ->where('jenis_absen_id', $id)
                ->whereYear('created_at', $filterYear)
                ->whereMonth('created_at', $filterMonth)
                ->count();
        }

        // Kirim data tahun & bulan untuk dropdown
        $data['selectedYear'] = $filterYear;
        $data['selectedMonth'] = $filterMonth;
        $data['rekapAbsensi'] = JenisAbsen::with([
            'uraianJenisAbsensi.absensi' => function ($query) use ($filterYear, $filterMonth, $user) {
                $query->where('user_id', $user)
                    ->whereYear('created_at', $filterYear)
                    ->whereMonth('created_at', $filterMonth);
            }
        ])->get();

        return view("main.absensi.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        //
        $user = Auth::id();
        $today = Carbon::now('Asia/Jakarta')->toDateString(); // Format: YYYY-MM-DD

        $data['dataUser'] = User::findOrFail($user);
        $data['dataShift'] = SetShift::whereJsonContains('user_id', strval($user))->first();
        $data['dataJenisAbsen'] = JenisAbsen::all();

        $data['dataAbsen'] = Absensi::where('user_id', $user)
            ->whereDate('jam_datang', $today)
            ->first(); // Ambil absensi hari ini

        $data['title'] = "Absensi";
        return view("main.absensi.create", $data);
    }
    public function izin()
    {
        //
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        //
        $user = Auth::id();
        $today = Carbon::now('Asia/Jakarta')->toDateString(); // Format: YYYY-MM-DD

        $data['dataUser'] = User::findOrFail($user);
        $data['dataShift'] = SetShift::whereJsonContains('user_id', strval($user))->first();
        $data['dataJenisAbsen'] = JenisAbsen::all();
        $data['dataUraianJenisAbsen'] = UraianJenisAbsen::all();

        $data['dataAbsen'] = Absensi::where('user_id', $user)
            ->whereDate('jam_datang', $today)
            ->first(); // Ambil absensi hari ini
        $data['absensi'] = Absensi::where('user_id', Auth::id())->first();
        $data['title'] = "Izin Kerja";
        return view("main.absensi.izin", $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
        $user = Auth::id();
        $today = Carbon::now('Asia/Jakarta')->toDateString(); // Format: YYYY-MM-DD

        // Cek apakah user sudah absen hari ini
        $absensi = Absensi::where('user_id', $user)
            ->whereDate('jam_datang', $today)
            ->first();

        if (!$absensi) {
            // Jika belum ada absensi, buat baru dengan jam datang
            Absensi::create([
                'user_id' => $user,
                'shift_id' => $request->shift_id,
                'jenis_absen_id' => $request->jenis_absen_id,
                'uraian_jenis_absen_id' => $request->uraian_jenis_absen_id,
                'jam_datang' => Carbon::now('Asia/Jakarta'), // Jam datang saat ini
                'lokasi_datang' => $request->lokasi, // Lokasi datang
            ]);
        } else {
            // Jika sudah ada, update dengan jam pulang
            $absensi->update([
                'jenis_absen_id' => $request->jenis_absen_id,
                'uraian_jenis_absen_id' => $request->uraian_jenis_absen_id,
                'jam_pulang' => Carbon::now('Asia/Jakarta'),
                'lokasi_pulang' => $request->lokasi, // Lokasi pulang
            ]);
        }

        return redirect()->back()->with('success', 'Absensi berhasil disimpan!');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
