<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Mail;

class ForgetController extends Controller
{
    function index()
    {
        $data['title'] = 'Reset Password';
        return view('auth.forget',$data);
    }

    public function sendReset(Request $request)
    {

        $dataUser = User::where([
            'nisn' =>$request->nisn,
            'nik' =>$request->nik,
            'email' => $request->email,
        ])->first();
        // dd($dataUser);

        if ($dataUser) {
            $password = Str::random(6);

            $objek = User::findOrFail($dataUser->id);
            // dd($objek);
            $objek->password = bcrypt($password);
            $objek->save();

            $details = [
                'nama' => $dataUser->name,
                'email' => $dataUser->email,
                'password' => $password
            ];

            Mail::send('email.emailforgotPassword', [
                'nama' => $dataUser->name,
                'email' => $dataUser->email,
                'password' => $password
            ], function ($message) use ($request) {
                $message->to($request->email);
                $message->subject('Email Reset password Mail');
            });

            // Mail::to($dataUser->email)->send(new MyTestMail($details));
            return redirect()->route('login')->withSuccess('Password telah diubah. Silahkan Cek Email anda');
            // return back()->with('pesan', 'Password telah diubah. Silahkan Cek Email anda');
        } else {
            return back()->withErrors('Data yang diinputkan tidak ditemukan.');
        }
        // $data['kantors'] = Organisasi::all();
        // return view('auth.forget');
    }
}
