<?php

namespace App\Http\Controllers\Auth;

use App\Models\User;
use App\Models\Jalur;
use App\Models\AboutApp;
use App\Models\Informasi;
use App\Models\Masyarakat;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

// use Auth;

class LoginController extends Controller
{
    public function index()
    {
        $data['title'] = 'Login Area';
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        $data['dataInformasi'] = Informasi::orderBy('id', 'DESC')->take(2)->get();
        return view('auth.login', $data);
    }

    public function processLogin(Request $request)
    {
        $request->validate([
            'username' => 'required',
            'password' => 'required|min:4',
        ]);

        $credential = ['username' => $request->username, 'password' => $request->password];
        $login = Auth::attempt($credential);
        if ($login) {
            // dd(Auth::check());
            return redirect()->route('home');
        } else {
            return redirect()->back()->withInput()->withErrors("Username & password yang anda masukkan salah /
            Hubungi Admin");
        }
    }

    public function logout()
    {
        Auth::logout();
        return redirect('/');
    }
}
