<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Absensi;
use App\Models\Kinerja;
use App\Models\AboutApp;
use App\Models\JenisAbsen;
use App\Models\JenisKerja;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Auth;

class KinerjaController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        //
        $data['title'] = "Cek Capaian Kinerja";
        // ABSENSI START
        $user = Auth::id();
        $data['dataUser'] = User::where('id', $user)
            ->first();
        $today = Carbon::now('Asia/Jakarta')->toDateString();
        $data['absenToday'] = Absensi::where('user_id', $user)
            ->whereDate('jam_datang', $today)
            ->first();

        $currentYear = Carbon::now()->year;

        $data['dataAbsensi'] = Absensi::where('user_id', $user)
            ->whereYear('created_at', $currentYear)
            ->get();

        // Rekapitulasi Absensi Tahunan
        // Ambil data absensi dalam tahun ini
        // Hitung jumlah masing-masing kategori dalam 1 tahun terakhir

        $data['hadir'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 1)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['cuti'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 2)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['izin'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 3)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['sakit'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 4)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['dinas_luar'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 5)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['pulang_cepat'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 6)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['alpa'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 7)
            ->whereYear('created_at', $currentYear)
            ->count();

        $data['terlambat'] = Absensi::where('user_id', $user)
            ->where('jenis_absen_id', 8)
            ->whereYear('created_at', $currentYear)
            ->count();
        // Rekapitulasi Absensi Tahunan

        // Ambil filter dari request
        $filterYear = $request->input('tahun', Carbon::now()->year);
        $filterMonth = $request->input('bulan', Carbon::now()->month);

        // Ambil data absensi berdasarkan filter bulan dan tahun
        $data['dataAbsensifilter'] = Absensi::where('user_id', $user)
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get();

        // Hitung jumlah masing-masing kategori dalam periode yang difilter
        $jenisAbsen = [
            'hadir' => 1,
            'cuti' => 2,
            'izin' => 3,
            'sakit' => 4,
            'dinas_luar' => 5,
            'pulang_cepat' => 6,
            'alpa' => 7,
            'terlambat' => 8,
        ];

        foreach ($jenisAbsen as $key => $id) {
            $data[$key] = Absensi::where('user_id', $user)
                ->where('jenis_absen_id', $id)
                ->whereYear('created_at', $filterYear)
                ->whereMonth('created_at', $filterMonth)
                ->count();
        }

        // Kirim data tahun & bulan untuk dropdown
        $data['selectedYear'] = $filterYear;
        $data['selectedMonth'] = $filterMonth;
        $data['rekapAbsensi'] = JenisAbsen::with([
            'uraianJenisAbsensi.absensi' => function ($query) use ($filterYear, $filterMonth, $user) {
                $query->where('user_id', $user)
                    ->whereYear('created_at', $filterYear)
                    ->whereMonth('created_at', $filterMonth);
            }
        ])->get();
        // ABSENSI END
        // KINERJA START
        $data['rekapKinerja'] = Kinerja::where('user_id', $user)
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get() ?? collect([]);

        $data['totalInput'] = Kinerja::where('user_id', $user)
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->count() ?? collect([]);

        $data['totalMenitInput'] = Kinerja::where('user_id', $user)
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get()
            ->sum(function ($item) {
                return \Carbon\Carbon::parse($item->jam_mulai)->diffInMinutes(\Carbon\Carbon::parse($item->jam_selesai));
            });


        $data['pending'] = Kinerja::where('user_id', $user)
            ->where('status_validasi', '=', 'pending')
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->count() ?? collect([]);

        $data['totalMenitPending'] = Kinerja::where('user_id', $user)
            ->where('status_validasi', '=', 'pending')
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get()
            ->sum(function ($item) {
                return \Carbon\Carbon::parse($item->jam_mulai)->diffInMinutes(\Carbon\Carbon::parse($item->jam_selesai));
            });

        $data['disetujui'] = Kinerja::where('user_id', $user)
            ->where('status_validasi', '=', 'disetujui')
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->count() ?? collect([]);

        $data['totalMenitDisetujui'] = Kinerja::where('user_id', $user)
            ->where('status_validasi', '=', 'disetujui')
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get()
            ->sum(function ($item) {
                return \Carbon\Carbon::parse($item->jam_mulai)->diffInMinutes(\Carbon\Carbon::parse($item->jam_selesai));
            });

        $data['ditolak'] = Kinerja::where('user_id', $user)
            ->where('status_validasi', '=', 'ditolak')
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->count() ?? collect([]);

        $data['totalMenitditolak'] = Kinerja::where('user_id', $user)
            ->where('status_validasi', '=', 'ditolak')
            ->whereYear('created_at', $filterYear)
            ->whereMonth('created_at', $filterMonth)
            ->get()
            ->sum(function ($item) {
                return \Carbon\Carbon::parse($item->jam_mulai)->diffInMinutes(\Carbon\Carbon::parse($item->jam_selesai));
            });


        // dd($data['totalMenitPending']);
        // KINERJA END
        return view("main.kinerja.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        //
        $data['title'] = "Input Aktivitas Kerja";
        $user = Auth::id();
        $data['dataUser'] = User::findOrFail($user);

        // Ambil data jenis kerja berdasarkan bidang_id user
        $data['dataJenisKerja'] = JenisKerja::where('bidang_id', $data['dataUser']->bidang_id)->get();

        // Ambil semua kinerja yang sudah diinput oleh user
        $data['dataKinerja'] = Kinerja::where('user_id', $user)
            ->select('id', 'tanggal', 'jenis_kerja_id') // Ambil data yang dibutuhkan
            ->get();

        return view("main.kinerja.create", $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $request->validate([
            'tanggal' => 'required|date',
            'jam_mulai' => 'required',
            'jam_selesai' => 'required',
            'jenis_kerja_id' => 'required',
            'aktivitas_lain' => 'nullable|string',
            'keterangan' => 'nullable|string',
            'bukti_foto' => 'required|nullable|image|max:2048',
            'latitude' => 'required',
            'longitude' => 'required',
        ]);

        $user = Auth::id();
        $buktiFoto = null;

        if ($request->hasFile('bukti_foto')) {
            $buktiFoto = $request->file('bukti_foto')->store('bukti_kinerja', 'public');
        }

        Kinerja::create([
            'user_id' => $user,
            'tanggal' => $request->tanggal,
            'jam_mulai' => $request->jam_mulai,
            'jam_selesai' => $request->jam_selesai,
            'jenis_kerja_id' => $request->jenis_kerja_id,
            'aktivitas_lain' => $request->aktivitas_lain,
            'keterangan' => $request->keterangan,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'bukti_foto' => $buktiFoto,
            'validator_id' => null,
            'status_validasi' => 'pending',
            'keterangan_validasi' => null
        ]);

        return redirect()->route('kinerja.create')->with('success', 'Kinerja berhasil disimpan!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
