<?php

namespace App\Http\Controllers\Main;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Darurat;
use Illuminate\Support\Facades\Auth;

class DaruratController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['dataDarurat'] = Darurat::orderBy('id', 'desc')
            ->where('masyarakat_id', $masyarakatId)
            ->get();
        $data['title'] = "Data Darurat Saya";
        return view("main.darurat.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['title'] = "Buat Pengaduan Darurat";
        return view("main.darurat.create", $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'lat' => 'required',
            'long' => 'required',
            'masyarakat_id' => 'required',
            // Other validation rules
        ]);

        $darurat = new Darurat();
        $darurat->keterangan = $request->keterangan;
        $darurat->lat = $request->lat;
        $darurat->long = $request->long;
        $darurat->masyarakat_id = $request->masyarakat_id;
        $darurat->status = $request->status;
        $darurat->save();

        return redirect()->route('darurat.index')->with('success', 'Data Darurat berhasil disimpan.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $aduan = Darurat::findOrFail($id);
        $aduan->delete();
        return back()->with('success', 'Data sudah di Hapus!');
    }
}
