<?php

namespace App\Http\Controllers\Main;

use App\Models\Quis;
use App\Models\User;
use App\Models\Kelas;
use App\Models\Mapel;
use App\Models\Siswa;
use App\Models\Jadwal;
use App\Models\Materi;
use App\Models\Latihan;
use App\Models\AboutApp;
use App\Models\Pengumuman;
use App\Models\UserVerify;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use App\Http\Controllers\Controller;
use App\Models\Informasi;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;

class HomeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        $user = Auth::user();
        $data['user'] = $user->name;
        $data['title'] = 'Dashboard';
        $data['dataInformasi'] = Informasi::orderBy('id', 'DESC')->take(2)->get();
        return view('main.home.home', $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function detailinfo($id)
    {
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        $data['title'] = 'Detail Informasi';
        // wajib
        $data['dataInformasi'] = Informasi::where('id', $id)->get();
        return view('main.home.detailinfo', $data);
    }

    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
