<?php

namespace App\Http\Controllers\Main;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\JawabanQuis;
use App\Models\Quisioner;
use Illuminate\Support\Facades\Auth;

class KuisionerController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['dataJawaban'] = JawabanQuis::orderBy('id', 'desc')
            ->with('quis', 'masyarakat')
            ->where('masyarakat_id', $masyarakatId)
            ->get();
        $data['title'] = "Jawaban Saya";
        return view("main.kuis.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id

        // Cek apakah masyarakat_id sudah ada di JawabanQuis
        $exists = JawabanQuis::where('masyarakat_id', $masyarakatId)->exists();

        if ($exists) {
            // Jika sudah ada, redirect ke halaman main/kuis
            return redirect('main/kuis')->with('warning', 'Anda sudah menjawab kuis.');
        }
        $data['saya'] = $masyarakatId;
        $data['pertanyaan'] = Quisioner::all();
        $data['title'] = "Beri Kami Penilaian";
        return view("main.kuis.create", $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'jenis_kuis.*' => 'required|string',
            'masyarakat_id' => 'required',
        ]);

        $masyarakat_id = $request->input('masyarakat_id');
        $jenis_kuis = $request->input('jenis_kuis');

        foreach ($jenis_kuis as $key => $jawaban) {
            $pertanyaan = Quisioner::find($key); // Asumsi bahwa $key adalah id dari pertanyaan

            if ($pertanyaan) {
                JawabanQuis::create([
                    'quis_id' => $pertanyaan->id,
                    'masyarakat_id' => $masyarakat_id,
                    'jawaban' => $jawaban,
                ]);
            }
        }

        return redirect('/main/kuis')->with('success', 'Jawaban Anda berhasil disimpan.');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
