<?php

namespace App\Http\Controllers\Main;

use App\Models\Pengaduan;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class PengaduanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['dataPengaduan'] = Pengaduan::orderBy('id', 'desc')
            ->where('id_masyarakat', $masyarakatId)
            ->get();
        $data['title'] = "Data Pengaduan";
        return view("main.pengaduan.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['title'] = "Buat Pengaduan";
        return view("main.pengaduan.create", $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // Validasi input
        $this->validate(
            $request,
            [
                'id_masyarakat' => 'required',
                'jenis_pengaduan' => 'required',
                'deskripsi' => 'required',
                'tgl_pengaduan' => 'required',
                'foto_pengaduan' => 'required|image|mimes:jpeg,png,jpg,gif',
                'status_pengaduan' => 'required',
            ],
            [
                'id_masyarakat.required' => 'id_masyarakat tidak boleh kosong',
                'jenis_pengaduan.required' => 'jenis_pengaduan tidak boleh kosong',
                'deskripsi.required' => 'deskripsi tidak boleh kosong',
                'tgl_pengaduan.required' => 'tgl_pengaduan tidak boleh kosong',
                'status_pengaduan.required' => 'status_pengaduan tidak boleh kosong',
                'foto_pengaduan.required' => 'foto_pengaduan tidak boleh kosong',
                'foto_pengaduan.image' => 'File harus berupa foto_pengaduan',
                'foto_pengaduan.mimes' => 'Format foto_pengaduan harus jpeg, png, jpg, atau gif',
            ]
        );

        // Simpan gambar yang diunggah
        $data = [
            'id_masyarakat' => $request->id_masyarakat,
            'jenis_pengaduan' => $request->jenis_pengaduan,
            'deskripsi' => $request->deskripsi,
            'tgl_pengaduan' => $request->tgl_pengaduan,
            'status_pengaduan' => $request->status_pengaduan,
            'foto_pengaduan' => $request->file('foto_pengaduan')->store('foto_pengaduan', 'public'),
        ];

        // Buat pengaduan dengan data yang telah dikumpulkan
        Pengaduan::create($data);

        return redirect('main/pengaduan')->with('success', 'Data berhasil dikirim!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $aduan = Pengaduan::findOrFail($id);
        $aduan->delete();
        return back()->with('success', 'Data sudah di Hapus!');
    }
}
