<?php

namespace App\Http\Controllers\Main;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Perizinan;
use Illuminate\Support\Facades\Auth;

class PerizinanController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['dataPerizinan'] = Perizinan::orderBy('id', 'desc')
            ->where('id_masyarakat', $masyarakatId)
            ->get();
        $data['title'] = "Data Perizinan";
        return view("main.perizinan.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $masyarakatId = Auth::id(); // atau Auth::user()->id
        $data['saya'] = $masyarakatId;
        $data['title'] = "Buat Permohonan Perizinan";
        return view("main.perizinan.create", $data);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        // Validasi input
        $this->validate(
            $request,
            [
                'id_masyarakat' => 'required',
                'nama' => 'required',
                'no_telp' => 'required',
                'tujuan_kegiatan' => 'required',
                'waktu_kegiatan' => 'required',
                'tempat_kegiatan' => 'required',
                'status_perizinan' => 'required',
            ],
            [
                'id_masyarakat.required' => 'id_masyarakat tidak boleh kosong',
                'nama.required' => 'nama tidak boleh kosong',
                'no_telp.required' => 'no_telp tidak boleh kosong',
                'tujuan_kegiatan.required' => 'tujuan_kegiatan tidak boleh kosong',
                'waktu_kegiatan.required' => 'waktu_kegiatan tidak boleh kosong',
                'tempat_kegiatan.required' => 'tempat_kegiatan tidak boleh kosong',
                'status_perizinans.required' => 'status_perizinans tidak boleh kosong',
            ]
        );

        // Simpan gambar yang diunggah
        $data = [
            'id_masyarakat' => $request->id_masyarakat,
            'nama' => $request->nama,
            'no_telp' => $request->no_telp,
            'tujuan_kegiatan' => $request->tujuan_kegiatan,
            'waktu_kegiatan' => $request->waktu_kegiatan,
            'tempat_kegiatan' => $request->tempat_kegiatan,
            'status_perizinan' => $request->status_perizinan,
        ];

        // Buat perizinan dengan data yang telah dikumpulkan
        Perizinan::create($data);

        return redirect('main/perizinan')->with('success', 'Data berhasil dikirim!');
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $aduan = Perizinan::findOrFail($id);
        $aduan->delete();
        return back()->with('success', 'Data sudah di Hapus!');
    }
}
