<?php

namespace App\Http\Controllers\Main;

use App\Models\User;
use App\Models\Siswa;
use App\Models\Biodata;
use App\Models\AboutApp;
use App\Models\Masyarakat;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        // wajib
        $aboutApp = AboutApp::first();

        // Cek apakah sudah array atau masih string JSON
        if (is_string($aboutApp->sosmed)) {
            $data['sosmed'] = json_decode($aboutApp->sosmed, true);
        } else {
            $data['sosmed'] = $aboutApp->sosmed; // Langsung pakai jika sudah array
        }

        $data['AboutApp'] = $aboutApp;
        // wajib
        $user = Auth::id();
        $data['dataUser'] = User::findOrFail($user);
        $data['dataBio'] = Biodata::where('user_id', $user)->first() ?? new Biodata();
        $data['title'] = "Profile";
        return view("main.profile.index", $data);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        $request->validate([
            'jk' => 'required',
            'ttl' => 'required',
            'nik' => 'required',
            'alamat' => 'required',
            'no_hp' => 'required',
        ]);

        $user = Auth::id();
        $bio = Biodata::where('user_id', $user)->first();

        if ($bio) {
            // Jika sudah ada, lakukan update
            $bio->update($request->all());
        } else {
            // Jika belum ada, buat baru
            Biodata::create(array_merge($request->all(), ['user_id' => $user]));
        }

        return redirect()->back()->with('success', 'Profil berhasil diperbarui');
    }

    public function reset(Request $request, string $id)
    {
        $user = Auth::id(); // atau Auth::user()->id
        $userId = User::findOrFail($user);

        $request->validate([
            // 'username' => 'required|max:255',
            'new_password' => 'nullable|min:4',
            'confirm_password' => 'nullable|same:new_password',
        ]);

        // $userId->username = $request->username;

        // Periksa apakah pengguna memasukkan kata sandi baru
        if ($request->filled('new_password') && $request->filled('confirm_password')) {
            // Pastikan kata sandi baru dan konfirmasi sesuai
            if ($request->new_password === $request->confirm_password) {
                $userId->password = bcrypt($request->new_password);
            } else {
                return redirect()->back()->with('error', 'Kata sandi baru dan konfirmasi tidak cocok.');
            }
        }

        $userId->save();

        return redirect()->back()->with('success', 'Profile updated successfully.');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
