<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class SetShift extends Model
{
    //
    use HasFactory;
    protected $guarded = ['id'];

    protected $casts = [
        'user_id' => 'array', // Menjadikan kolom user_id sebagai array saat diambil dari database
    ];
    // public function setUserIdAttribute($value)
    // {
    //     $this->attributes['user_id'] = json_encode($value);
    // }

    public function shift(): BelongsTo
    {
        return $this->belongsTo(Shift::class);
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
