<?php

namespace Database\Seeders;

use App\Models\Absensi;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class AbsensiSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $absensiData = [
            [
                'shift_id' => 1,
                'jenis_absen_id' => 1,
                'user_id' => 1,
                'jam_datang' => '08:00:00',
                'lokasi_datang' => '-6.2088, 106.8456',
                'jam_pulang' => '16:00:00',
                'lokasi_pulang' => '-6.2089, 106.8457'
            ],
            [
                'shift_id' => 2,
                'jenis_absen_id' => 2,
                'user_id' => 2,
                'jam_datang' => '16:30:00',
                'lokasi_datang' => '-6.2090, 106.8460',
                'jam_pulang' => '00:30:00',
                'lokasi_pulang' => '-6.2091, 106.8461'
            ],
        ];

        foreach ($absensiData as $absen) {
            Absensi::create($absen);
        }
    }
}
