<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Biodata;
use Illuminate\Support\Carbon;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class BiodataSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        // Ambil user pertama sebagai contoh
        $user = User::first();

        if ($user) {
            Biodata::create([
                'user_id' => $user->id,
                'ttl' => Carbon::parse('1990-05-20'),
                'nik' => '3201012005990001',
                'alamat' => 'Jl. Merdeka No. 123, Jakarta',
                'no_hp' => '081234567890',
                'npwp' => '09.123.456.7-891.000',
                'no_kontrak' => '2023/DISHUB/001',
                'sertifikasi' => 'Sertifikasi Transportasi',
            ]);
        }
    }
}
