<?php

namespace Database\Seeders;

use App\Models\Bidang;
use App\Models\JenisKerja;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class JenisKerjaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        // Ambil bidang pertama sebagai contoh
        $bidang = Bidang::first();

        if ($bidang) {
            JenisKerja::create([
                'bidang_id' => $bidang->id,
                'uraian' => 'Pengawasan Lalu Lintas',
            ]);

            JenisKerja::create([
                'bidang_id' => $bidang->id,
                'uraian' => 'Pemeriksaan Kendaraan',
            ]);
        }
    }
}
