<?php

namespace Database\Seeders;

use Carbon\Carbon;
use App\Models\Kinerja;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class KinerjaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $kinerjaData = [
            [
                'user_id' => 1,
                'tanggal' => Carbon::now()->toDateString(),
                'jam_mulai' => '08:00:00',
                'jam_selesai' => '12:00:00',
                'jenis_kerja_id' => 1,
                'aktivitas_lain' => 'Rapat internal',
                'keterangan' => 'Diskusi terkait proyek baru',
                'bukti_foto' => 'bukti/rapat1.jpg',
                'latitude' => '-6.2088',
                'longitude' => '106.8456',
                'validator_id' => 1,
                'status_validasi' => 'pending',
                'keterangan_validasi' => null,
            ],
            [
                'user_id' => 2,
                'tanggal' => Carbon::now()->toDateString(),
                'jam_mulai' => '13:00:00',
                'jam_selesai' => '17:00:00',
                'jenis_kerja_id' => 2,
                'aktivitas_lain' => 'Pengawasan lapangan',
                'keterangan' => 'Meninjau area proyek pelabuhan',
                'bukti_foto' => 'bukti/pengawasan1.jpg',
                'latitude' => '-6.2090',
                'longitude' => '106.8460',
                'validator_id' => 1,
                'status_validasi' => 'disetujui',
                'keterangan_validasi' => 'Laporan diterima',
            ],
        ];

        foreach ($kinerjaData as $kinerja) {
            Kinerja::create($kinerja);
        }
    }
}
