<?php

namespace Database\Seeders;

use App\Models\Shift;
use Illuminate\Database\Seeder;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class ShiftSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        $shifts = [
            ['nama' => 'Pagi', 'datang' => '08:00:00', 'pulang' => '16:00:00'], // Shift Pagi
            ['nama' => 'Siang', 'datang' => '16:00:00', 'pulang' => '00:00:00'], // Shift Sore
            ['nama' => 'Malam', 'datang' => '00:00:00', 'pulang' => '08:00:00'], // Shift Malam
        ];

        foreach ($shifts as $shift) {
            Shift::create($shift);
        }
    }
}
