<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\Bidang;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;

class UserSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        //
        // Ambil bidang pertama sebagai contoh
        $bidang = Bidang::first();

        if ($bidang) {
            User::create([
                'bidang_id' => $bidang->id,
                'name' => 'Admin Dishub',
                'username' => 'admin',
                'email' => 'admin@dishub.go.id',
                'password' => Hash::make('password'),
            ]);

            User::create([
                'bidang_id' => $bidang->id,
                'name' => 'Pegawai A',
                'username' => 'pegawai_a',
                'email' => 'pegawai_a@dishub.go.id',
                'password' => Hash::make('password'),
            ]);
        }
    }
}
