@extends('layouts.app')
@section('content')
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container ">
            <div class="row">
                <div class="col-lg-6 align-self-center wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.25s"">
                    <h5 align="center" class="mb-1 fw-bold ">Selamat Datang di
                        <br> {{ $AboutApp->nama_singkat }}
                    </h5>
                    <p align="center" class="mb-4">Silahkan login ke akun kamu untuk masuk</p>
                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger" role="alert">
                            {!! implode('', $errors->all('<li>:message</li>')) !!}
                        </div>
                    @endif
                    <form id="formAuthentication" class="mb-3" method="post" action="{{ route('login.process') }}">
                        @csrf
                        <div class="mb-3">
                            <label for="username" class="form-label">Username</label>
                            <input type="text" name="username" class="form-control" placeholder="Masukkan username"
                                value="{{ old('username') }}">
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <div class="d-flex justify-content-between">
                                <label class="form-label" for="password">Password</label>
                            </div>
                            <div class="input-group input-group-merge">
                                <input type="password" name="password" class="form-control" placeholder="Masukkan Password">
                                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                            </div>
                        </div>
                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember-me" />
                                <label class="form-check-label" for="remember-me"> Ingat saya </label>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary d-grid w-100">Masuk</button>
                    </form>

                    {{-- <p class="text-center">
                        <span>Belum punya akun?</span>
                        <a href="{{ url('/auth/register') }}">
                            <span>Daftar Akun Sekarang</span>
                        </a>
                    </p> --}}
                </div>
                <div class="col-lg-6 wow fadeInRights">
                    <h3 class="fw-bold">Informasi Terbaru</h3>
                    @foreach ($dataInformasi as $info)
                        <div class="card mb-3">
                            <div class="card-body">
                                <h5 class="card-title">{{ $info->judul }}</h5>
                                <p class="card-text">{{ Str::limit($info->deskripsi, 100) }}</p>
                                <a href="{{ route('home.detailinfo', $info->id) }}" class="btn btn-warning btn-sm">
                                    Baca Selengkapnya
                                </a>
                                <p style="font-size: 8pt">
                                    {{ date('d-m-Y', strtotime($info->created_at)) }}
                                    &raquo;
                                    By Admin
                                </p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
@endsection
