@extends('layouts.app')
@section('title', 'Register')
@section('content')

    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container ">
            <div class="row">
                <div class="col-lg-6 align-self-center wow fadeInLeft" data-wow-duration="0.5s" data-wow-delay="0.25s"">
                    <h5 align="center" class="mb-1 fw-bold ">Selamat Datang di
                        <br> E-KIN PJLPBPP
                    </h5>
                    <p align="center" class="mb-4">Silahkan register akun kamu untuk masuk</p>
                    @if (session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if ($errors->any())
                        <div class="alert alert-danger" role="alert">
                            {!! implode('', $errors->all('<li>:message</li>')) !!}
                        </div>
                    @endif
                    <form action="{{ route('register.store') }}" id="formAuthentication" class="mb-3" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        <div class="mb-3">
                            <label for="nama_masyarakat" class="form-label">Nama</label>
                            <input type="text" class="form-control" id="nama_masyarakat" name="nama_masyarakat"
                                placeholder="Masukkan nama Lengkap" autofocus required />
                        </div>
                        <div class="form-group mb-3">
                            <label>Jenis Kelamin*</label>
                            <select name="jenis_kelamin" class="form-control" required>
                                <option value="">Pilih</option>
                                <option value="Laki-laki">Laki-laki</option>
                                <option value="Perempuan">Perempuan</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label for="no_telp" class="form-label">Nomor Handphone</label>
                            <input type="number" class="form-control" id="no_telp" name="no_telp"
                                placeholder="Masukkan nama Lengkap" autofocus required />
                        </div>
                        <div class="mb-3">
                            <label for="alamat" class="form-label">Alamat</label>
                            <input type="text" class="form-control" id="alamat" name="alamat"
                                placeholder="Masukkan nama Lengkap" autofocus required />
                        </div>

                        <div class="mb-3">
                            <label for="email" class="form-label">Email (Aktif)</label>
                            <input type="text" class="form-control" id="email" name="email"
                                placeholder="Masukkan email" required />
                        </div>
                        <div class="mb-3 form-password-toggle">
                            <label class="form-label" for="password">Password</label>
                            <div class="input-group input-group-merge">
                                <input type="password" id="password" class="form-control" name="password"
                                    placeholder="&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;&#xb7;"
                                    aria-describedby="password" required />
                                <span class="input-group-text cursor-pointer"><i class="ti ti-eye-off"></i></span>
                            </div>
                        </div>

                        <label class="form-label" for="password">Konfirmasi Password</label>
                        <div class="input-group mb-3">
                            <input type="password" name="password_confirmation" class="form-control"
                                placeholder="Konfirmasi Password" required>
                            <div class="input-group-text">
                                <span class="fas fa-lock"></span>
                            </div>
                        </div>

                        <div class="mb-3">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="terms-conditions" name="terms"
                                    required />
                                <label class="form-check-label" for="terms-conditions">
                                    Data yang saya masukkan telah benar
                                    <a href="javascript:void(0);"> </a>
                                </label>
                            </div>
                        </div>
                        <button class="btn btn-primary d-grid w-100 mb-4">Daftar</button>
                    </form>
                    <p class="text-center">
                        <span>Sudah punya akun?</span>
                        <a href="{{ url('/auth/login') }}">
                            <span>Login Sekarang</span>
                        </a>
                    </p>
                </div>
                <div class="col-lg-6 wow fadeInRights">
                    <div class="right-image wow fadeInRight" data-wow-duration="1s" data-wow-delay="0.5s">
                        <center>
                            <img style="width: 70%" src="{{ URL::to('images/LOGO-WEBSITE.png') }}" alt="team meeting" />
                        </center>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection
