<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Data Kinerja Pegawai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        img {
            max-width: 70px;
            height: auto;
        }

        .container {
            width: 100%;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            margin: 0;
            padding: 0;
            font-size: 16px;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>Data Kinerja Pegawai</h2>
        <h3>Periode: {{ $judulPeriode }}</h3>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Shift</th>
                <th>Jenis Absen</th>
                <th>Uraian Absensi</th>
                <th>Jam Datan</th>
                <th>Lokasi Datang</th>
                <th>Jam Pulang</th>
                <th>Lokasi Pulang</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item['user']['name'] ?? '-' }}</td>
                    <td>{{ $item['shift']['nama'] ?? '-' }}</td>
                    <td>{{ $item['jenis']['nama'] ?? '-' }}</td>
                    <td>{{ $item['uraian']['nama'] ?? '-' }}</td>
                    <td>{{ date('d-m-Y', strtotime($item['jam_datang'])) }}</td>
                    <td>{{ $item['lokasi_datang'] ?? '-' }}</td>
                    <td>{{ date('d-m-Y', strtotime($item['jam_pulang'])) }}</td>
                    <td>{{ $item['lokasi_pulang'] ?? '-' }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
