<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Data Kinerja Pegawai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        img {
            max-width: 70px;
            height: auto;
        }

        .container {
            width: 100%;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            margin: 0;
            padding: 0;
            font-size: 16px;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>Data Kinerja Pegawai</h2>
        <h3>Periode: {{ $judulPeriode }}</h3>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Jabatan</th>
                <th>Tanggal</th>
                <th>Jam Mulai</th>
                <th>Jam Selesai</th>
                <th>Aktivitas Kerja</th>
                <th>Aktivitas Lain</th>
                <th>Keterangan</th>
                <th>Bukti Foto</th>
                <th>Validator</th>
                <th>Status Validasi</th>
                <th>Keterangan Validasi</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($data as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>{{ $item['user']['name'] ?? '-' }}</td>
                    <td>{{ $item['user']['bidang']['nama'] ?? '-' }}</td>
                    <td>{{ date('d-m-Y', strtotime($item['tanggal'])) }}</td>
                    <td>{{ $item['jam_mulai'] }}</td>
                    <td>{{ $item['jam_selesai'] }}</td>
                    <td>{{ $item['jenis']['uraian'] ?? '-' }}</td>
                    <td>{{ $item['aktivitas_lain'] }}</td>
                    <td>{{ $item['keterangan'] }}</td>
                    <td>
                        @if ($item['bukti_foto'])
                            <img src="{{ public_path('storage/' . $item['bukti_foto']) }}">
                        @else
                            -
                        @endif
                    </td>
                    <td>{{ $item['validator']['name'] ?? '-' }}</td>
                    <td>{{ $item['status_validasi'] }}</td>
                    <td>{{ $item['keterangan_validasi'] }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>
