<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">
    <link rel="preconnect" href="https://fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&display=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    {{-- tabel manual  --}}

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

    <title>{{ $AboutApp->nama_panjang }} - {{ $title }}</title>
    <link rel="icon" href="{{ asset('storage/' . $AboutApp->icon) }}">

    <!-- Bootstrap core CSS -->
    <link href="{{ url('assets/frontend') }}/vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet" />

    <!-- Additional CSS Files -->
    <link rel="stylesheet" href="{{ url('assets/frontend') }}/assets/css/fontawesome.css" />
    <link rel="stylesheet" href="{{ url('assets/frontend') }}/assets/css/templatemo-space-dynamic.css" />
    <link rel="stylesheet" href="{{ url('assets/frontend') }}/assets/css/animated.css" />
    <link rel="stylesheet" href="{{ url('assets/frontend') }}/assets/css/owl.css" />
    <!--

TemplateMo 562 Space Dynamic

https://templatemo.com/tm-562-space-dynamic

-->
    <!-- sweet aler -->
    <script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js')}}"></script>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"
        integrity="sha384-ka7Sk0Gln4gmtz2MlQnikT1wXgYsOg+OMhuP+IlRH9sENBO0LRn5q+8nbTov4+1p" crossorigin="anonymous">
    </script>

</head>

<body>
    <link href="{{ URL::to('assets/frontend/assets/css/dropdown.css') }}" rel="stylesheet">
    <!-- ***** Preloader Start ***** -->
    {{-- <div id="js-preloader" class="js-preloader">
        <div class="preloader-inner">
            <span class="dot"></span>
            <div class="dots">
                <span></span>
                <span></span>
                <span></span>
            </div>
        </div>
    </div> --}}
    <!-- ***** Preloader End ***** -->

    <!-- ***** Header Area Start ***** -->
    <header class="header-area header-sticky wow slideInDown" data-wow-duration="0.75s" data-wow-delay="0s">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <nav class="main-nav">
                        @guest
                            <a href="{{ '/' }}" class="logo">
                                <h4>{{ $AboutApp->nama_singkat }}</span></h4>
                            </a>
                            <ul class="nav">
                                {{-- <li class="scroll-to-section">
                                    <a href="#top" class="{{ Request::is('/') ? 'active' : '' }}">Home</a>
                                </li>
                                <li class="scroll-to-section">
                                    <a href="#about">About Us </a>
                                </li>
                                <li class="scroll-to-section">
                                    <a href="#kontak">Kontak </a>
                                </li> --}}

                                <li class="scroll-to-section">
                                    <div class="main-red-button">
                                        <a href="{{ url('admin') }}">Admin Panel</a>
                                    </div>
                                </li>

                            </ul>
                        @endguest
                        @auth
                            <a href="{{ '/main/home' }}" class="logo">
                                <h4>{{ $AboutApp->nama_singkat }}</span></h4>
                            </a>
                            <ul class="nav">
                                <li class="scroll-to-section">
                                    <a href="{{ '/main/home' }}" class="{{ Request::is('/') ? 'active' : '' }}">Home</a>
                                </li>
                                <li class="scroll-to-section">
                                    <a href="{{ url('main/absensi') }}"
                                        class="{{ Request::is('main/absensi*') ? 'active' : '' }}">Absensi
                                    </a>
                                </li>
                                <li class="scroll-to-section">
                                    <a href="{{ url('main/kinerja') }}"
                                        class="{{ Request::is('main/kinerja*') ? 'active' : '' }}">Aktivitas Kerja </a>
                                </li>
                                <li class="scroll-to-section">
                                    <a href="{{ url('main/profile') }}"
                                        class="{{ Request::is('main/profile*') ? 'active' : '' }}">Profile </a>
                                </li>

                                <li class="scroll-to-section">
                                    <div class="main-red-button">
                                        <a href="{{ url('logout') }}">Logout</a>
                                    </div>
                                </li>

                            </ul>
                        @endauth

                        <a class='menu-trigger'>
                            <span>Menu</span>

                        </a>
                        <!-- ***** Menu End ***** -->
                    </nav>
                </div>
            </div>
        </div>
    </header>
    <!-- ***** Header Area End ***** --><!-- Footer -->
    @yield('content')
    <br>
    <footer class="bg-dark text-white pt-4 pb-2">
        <div class="container">
            <div class="row text-center text-md-start">
                <a href="#top" class="text-white text-decoration-none">
                    <h4 class="fw-bold">{{ $AboutApp->nama_panjang }}</h4>
                </a>
                <!-- Logo & Lokasi -->
                <div class="col-md-4 mb-4">
                    <h5>Lokasi</h5>
                    <div class="ratio ratio-16x9">
                        <iframe src="https://maps.google.com/maps?q={{ urlencode($AboutApp->maps) }}&z=15&output=embed"
                            frameborder="0" allowfullscreen>
                        </iframe>
                    </div>
                </div>

                <!-- Contact Us -->
                <div class="col-md-4 mb-4">
                    <h5>Contact Us</h5>
                    <ul class="list-unstyled">
                        <li><i class="fa fa-envelope"></i> {{ $AboutApp->email }}</li>
                        <li><i class="fa fa-whatsapp"></i> {{ $AboutApp->telp }}</li>
                        <li><i class="fa fa-map-marker"></i> {{ $AboutApp->alamat }}</li>
                    </ul>
                </div>

                <!-- Social Media -->
                <div class="col-md-4 mb-4">
                    <h5>Social Media</h5>
                    <ul class="list-unstyled ">
                        @foreach ($sosmed as $item)
                            <li>
                                <a target="_blank" href="{{ $item['url'] }}" class="text-white text-decoration-none">
                                    <i class="fa fa-{{ strtolower($item['platform']) }} fa-lg"></i>
                                    {{ $item['platform'] }}
                                </a>
                            </li>
                        @endforeach
                    </ul>
                </div>
            </div>

            <!-- Copyright -->
            <div class="text-center mt-3">
                <p class="mb-0">Copyright © {{ date('Y') }} . All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Footer -->
    <!-- Scripts -->
    <script src="{{ URL::to('assets/frontend/vendor/jquery/jquery.min.js') }}"></script>
    <script src="{{ URL::to('assets/frontend/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ URL::to('assets/frontend/assets/js/owl-carousel.js') }}"></script>
    <script src="{{ URL::to('assets/frontend/assets/js/animation.js') }}"></script>
    <script src="{{ URL::to('assets/frontend/assets/js/imagesloaded.js') }}"></script>
    <script src="{{ URL::to('assets/frontend/assets/js/templatemo-custom.js') }}"></script>
    <script src="{{ URL::to('assets/frontend/assets/js/main.js') }}"></script>
    {{-- tabel manual --}}
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTable').DataTable();
        });
    </script>
    @stack('js')

</body>

</html>
