@extends('layouts.app')
@section('content')
    <!-- Content -->

    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">

                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <!-- Account -->

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}
                        <h2>Absensi</h2>
                        <p>Selamat datang, {{ $dataUser->name }}</p>

                        @if (!$dataAbsen)
                            <form action="{{ route('absensi.update', $dataUser->id) }}" method="POST">
                                @method('put')
                                @csrf
                                {{-- user id  --}}
                                <input class="form-control mt-3" type="text" value="{{ $dataUser->name }}" disabled />
                                <input class="form-control mt-3" type="hidden" name="user_id"
                                    value="{{ $dataUser->id }}" />
                                {{-- user id  --}}
                                {{-- shift id  --}}
                                @if ($dataShift)
                                    <input class="form-control mt-3" type="text"
                                        value="Shift {{ $dataShift->shift->nama }}" disabled />
                                    <input class="form-control" type="hidden" name="shift_id"
                                        value="{{ $dataShift->shift_id }}" />
                                @else
                                    <input class="form-control" type="text" value="Tidak ada shift" disabled />
                                @endif
                                {{-- shift id  --}}
                                <select name="jenis_absen_id" id="jenis_absen_id" class="form-control mt-3" readonly>
                                    @foreach ($dataJenisAbsen as $item)
                                        <option value="{{ $item->id }}">{{ $item->nama }}</option>
                                    @endforeach
                                </select>
                                <input type="hidden" id="lokasi" name="lokasi">
                                <div class="d-grid gap-2 mt-3">
                                    <button type="button" class="btn btn-primary" onclick="ambilLokasi()">Absen
                                        Datang</button>
                                </div>
                            </form>
                        @elseif ($dataAbsen && !$dataAbsen->jam_pulang)
                            <form action="{{ route('absensi.update', $dataUser->id) }}" method="POST">
                                @method('put')
                                @csrf
                                <input class="form-control mt-3" type="text" value="{{ $dataUser->name }}" disabled />

                                @if ($dataShift)
                                    <input class="form-control mt-3" type="text"
                                        value="Shift {{ $dataShift->shift->nama }}" disabled />
                                @else
                                    <input class="form-control" type="text" value="Tidak ada shift" disabled />
                                @endif
                                <input class="form-control mt-3" type="hidden" name="jenis_absen_id"
                                    value="{{ $dataAbsen->jenis_absen_id }}" readonly />
                                <input class="form-control mt-3" type="text" value="{{ $dataAbsen->jenisAbsen->nama }}"
                                    readonly />
                                <input type="hidden" id="lokasi" name="lokasi">
                                <div class="d-grid gap-2 mt-3">
                                    <button type="button" class="btn btn-warning" onclick="ambilLokasi()">Absen
                                        Pulang</button>
                                    <p><a href="{{ url('/') }}" class="btn btn-danger">Kembali</a></p>
                                </div>
                            </form>
                        @else
                            <p class="alert alert-success">Anda sudah absen hari ini! ✅</p>
                            <p><a href="{{ url('/') }}" class="btn btn-danger">Kembali</a></p>
                        @endif
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function ambilLokasi() {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(function(position) {
                    let latitude = position.coords.latitude;
                    let longitude = position.coords.longitude;
                    document.getElementById("lokasi").value = latitude + "," + longitude;
                    document.querySelector("form").submit();
                }, function(error) {
                    alert("Gagal mendapatkan lokasi! Pastikan GPS aktif.");
                });
            } else {
                alert("Geolocation tidak didukung oleh browser ini.");
            }
        }
    </script>
@endsection
