@extends('layouts.app')
@section('content')
    <!-- Content -->
    <!-- Count -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            @if (session('warning'))
                <div class="alert alert-warning">{{ session('warning') }}</div>
            @endif
            @if (session('delete'))
                <div class="alert alert-danger">{{ session('delete') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger" role="alert">
                    {!! implode('', $errors->all('<li>:message</li>')) !!}
                </div>
            @endif
            <!-- Website Analytics -->
        </div>
    </div>
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-12">
                            <h3 class="fw-bold mb-3">{{ $title }} </h3>
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h3>{{ $dataUser->name }}</h3>
                                </div>
                            </div>
                            {{-- Absensi Hari ini dan tahunan  --}}
                            <div class="card mb-3">
                                <div class="card-body">
                                    <div class="row">

                                        <div class="col-lg-4">
                                            <p><i class="fa fa-calendar"></i>&nbsp; Presensi Hari Ini</p>
                                            <div class="table-responsive">
                                                <table class="table table-bordered text-center">
                                                    <thead class="bg-info text-dark">
                                                        <tr>
                                                            <th>Jam Datang</th>
                                                            <th>Jam Pulang</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody class="table table-bordered">
                                                        @if ($absenToday)
                                                            <tr>
                                                                <td>
                                                                    {{ $absenToday->jam_datang ? date('H:i', strtotime($absenToday->jam_datang)) : '-' }}
                                                                </td>
                                                                </td>
                                                                <td>
                                                                    {{ $absenToday->jam_pulang ? date('H:i', strtotime($absenToday->jam_pulang)) : '-' }}
                                                                </td>
                                                            </tr>
                                                        @else
                                                            <tr>
                                                                <td colspan="2">Belum ada absensi hari ini</td>
                                                            </tr>
                                                        @endif
                                                    </tbody>

                                                </table>
                                            </div>

                                        </div>
                                        <div class="col-lg-8">
                                            <p><i class="fa fa-calendar"></i>&nbsp; Rekapitulasi Absensi Tahunan</p>
                                            <div class="table-responsive"> <!-- Tambahkan div ini -->
                                                <table class="table table-bordered text-center">
                                                    <thead class="bg-info text-dark"> <!-- Gunakan class Bootstrap -->
                                                        <tr>
                                                            <th>Hadir</th>
                                                            <th>Cuti</th>
                                                            <th>Izin</th>
                                                            <th>Sakit</th>
                                                            <th>Dinas Luar</th>
                                                            <th>Pulang Cepat</th>
                                                            <th>Alpa</th>
                                                            <th>Terlambat</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <tr>
                                                            <td>{{ $hadir }} </td>
                                                            <td>{{ $cuti }}</td>
                                                            <td>{{ $izin }}</td>
                                                            <td>{{ $sakit }}</td>
                                                            <td>{{ $dinas_luar }}</td>
                                                            <td>{{ $pulang_cepat }}</td>
                                                            <td>{{ $alpa }}</td>
                                                            <td>{{ $terlambat }}</td>
                                                        </tr>
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            {{-- Absensi Hari ini dan tahunan  --}}

                            {{-- Filter Detail Rekap  --}}
                            <div class="card mb-3">
                                <div class="card-body">
                                    <form method="GET" action="{{ route('absensi.index') }}">
                                        <div class="row">
                                            <div class="col-lg-5">
                                                <label for="bulan">Bulan</label>
                                                <select name="bulan" id="bulan" class="form-control">
                                                    @foreach (range(1, 12) as $month)
                                                        <option value="{{ $month }}"
                                                            {{ $selectedMonth == $month ? 'selected' : '' }}>
                                                            {{ DateTime::createFromFormat('!m', $month)->format('F') }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-5">
                                                <label for="tahun">Tahun</label>
                                                <select name="tahun" id="tahun" class="form-control">
                                                    @foreach (range(date('Y') - 5, date('Y')) as $year)
                                                        <option value="{{ $year }}"
                                                            {{ $selectedYear == $year ? 'selected' : '' }}>
                                                            {{ $year }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-2 d-flex align-items-end">
                                                <button type="submit" class="btn btn-primary w-100">Filter</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            {{-- Filter Detail Rekap  --}}

                            {{-- Detail Rekap  --}}
                            <div class="card mb-3">
                                <div class="card-body">
                                    <p><i class="fa fa-calendar"></i>&nbsp; Detail Rekap Absensi
                                        ({{ DateTime::createFromFormat('!m', $selectedMonth)->format('F') }} -
                                        {{ $selectedYear }})
                                    </p>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="bg-info text-dark">
                                                <tr>
                                                    <th>Jenis Absensi</th>
                                                    <th>Uraian Jenis Absensi</th>
                                                    <th>Jumlah</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($rekapAbsensi as $jenis)
                                                    @php $rowspan = $jenis->uraianJenisAbsensi->count(); @endphp
                                                    @if ($rowspan > 0)
                                                        <tr>
                                                            <td rowspan="{{ $rowspan }}">{{ $jenis->nama }}</td>
                                                            <td>{{ $jenis->uraianJenisAbsensi[0]->nama }}</td>
                                                            <td>{{ $jenis->uraianJenisAbsensi[0]->absensi->count() }} hari
                                                            </td>
                                                        </tr>
                                                        @for ($i = 1; $i < $rowspan; $i++)
                                                            <tr>
                                                                <td>{{ $jenis->uraianJenisAbsensi[$i]->nama }}</td>
                                                                <td>{{ $jenis->uraianJenisAbsensi[$i]->absensi->count() }}
                                                                    hari
                                                                </td>
                                                            </tr>
                                                        @endfor
                                                    @endif
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            {{-- Detail Rekap  --}}

                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--/ Content -->
@endsection
