@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}
                        <h1 style="text-align: center">Buat Pengaduan Darurat Anda</h1>
                        <p style="text-align: center">Lampirkan Lokasi Kejadian Nyata</p>

                        <form action="{{ route('darurat.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="form-group mb-3">
                                    <label>keterangan*</label>
                                    <textarea name="keterangan" id="keterangan" cols="20" rows="5" class="form-control"></textarea>
                                </div>
                                <div class="form-group mb-3">
                                    <label>Lokasi Kejadian*</label>
                                    <input type="text" id="location" class="form-control" disabled>
                                    <iframe id="map" width="100%" height="300" style="border:0"
                                        allowfullscreen></iframe>
                                </div>
                            </div>

                            <div class="col-lg-12 form-group mb-3">
                                <input type="hidden" name="lat" id="lat">
                                <input type="hidden" name="long" id="long">
                                <input type="hidden" name="status" value="Pending" class="form-control" required>
                                <input type="hidden" name="masyarakat_id" value="{{ Auth::id() }}" class="form-control"
                                    required>
                                <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                <a href="{{ url('main/darurat') }}" class="btn btn-danger">Kembali</a>
                            </div>
                        </form>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>


    <!--/ Content -->
@endsection
@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', (event) => {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        const lat = position.coords.latitude;
                        const long = position.coords.longitude;

                        // Update hidden inputs
                        document.getElementById('lat').value = lat;
                        document.getElementById('long').value = long;

                        // Update location text input
                        document.getElementById('location').value = `${lat}, ${long}`;

                        // Update map iframe
                        const mapUrl = `https://maps.google.com/maps?q=${lat},${long}&z=15&output=embed`;
                        document.getElementById('map').src = mapUrl;
                    },
                    function(error) {
                        console.error('Error occurred. Error code: ' + error.code);
                        alert('Gagal mendapatkan lokasi. Pastikan lokasi diaktifkan dan izinkan akses.');
                    }, {
                        enableHighAccuracy: true,
                        timeout: 5000,
                        maximumAge: 0
                    }
                );
            } else {
                alert('Geolocation tidak didukung oleh browser ini.');
            }
        });
    </script>
@endpush
