@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="container-fluid" style="padding-left: 1%;">
                    <a href="{{ url('main/darurat/create') }}" class="btn btn-danger">
                        <i class="fas fa-exclamation-triangle"></i> Tanggap Darurat
                    </a>
                </div>
                <br>
                <br>
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}

                        <div class="table-responsive">
                            <table id="dataTable" class="table border-top">
                                <thead>
                                    <tr>
                                    <tr>
                                        <th>No</th>
                                        <th>Si Pengadu</th>
                                        <th>Tanggal Kejadian</th>
                                        <th>Lokasi Kejadian </th>
                                        <th>Status </th>
                                        <th>Keterangan </th>
                                        <th>Waktu Update Terakhir </th>
                                        <th>Aksi</th>
                                    </tr>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    @php
                                        $urutan = 1;
                                    @endphp
                                    @foreach ($dataDarurat as $item)
                                        <tr>
                                            <td>{{ $urutan++ }}</td>
                                            <td>{{ $item->masyarakat->nama_masyarakat }}</td>
                                            <td>{{ date('l / d-m-Y', strtotime($item->created_at)) }}</td>
                                            <td>
                                                <iframe width="200" height="150"
                                                    src="https://maps.google.com/maps?q={{ $item->lat }},{{ $item->long }}&z=15&output=embed"
                                                    frameborder="0" style="border:0" allowfullscreen>
                                                </iframe>
                                            </td>
                                            <td>
                                                @if ($item->status == 'Tidak Terjangkau')
                                                    <span class="btn btn-danger">{{ $item->status }}</span>
                                                @elseif ($item->status == 'Diproses')
                                                    <span class="btn btn-primary">{{ $item->status }}</span>
                                                @elseif ($item->status == 'Terselesaikan')
                                                    <span class="btn btn-success">{{ $item->status }}</span>
                                                @elseif ($item->status == 'Pending')
                                                    <span class="btn btn-warning">{{ $item->status }}</span>
                                                @else
                                                    <span>{{ $item->status }}</span>
                                                @endif
                                            </td>
                                            <td>{{ $item->keterangan }}</td>
                                            <td>{{ date('l / d-m-Y H:i', strtotime($item->updated_at)) }}</td>
                                            <td>
                                                @if ($item->status == 'Pending')
                                                    <form action="{{ route('darurat.destroy', $item->id) }}" method="POST"
                                                        class="d-inline">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="submit" class="btn btn-danger border-0"
                                                            onclick="return confirm('Are you sure?'); return false;"><i
                                                                class="fa fa-trash"></i></button>
                                                    </form>
                                                @else
                                                    <a href="#" class="btn btn-danger">
                                                        <i class="fa fa-calendar"></i>
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach

                                    <!-- Tambahkan lebih banyak baris dengan contoh data sesuai kebutuhan -->
                                </tbody>
                            </table>
                        </div>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
