@extends('layouts.app')
@section('content')
    <!-- Content -->
    <!-- Count -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            @if (session('warning'))
                <div class="alert alert-warning">{{ session('warning') }}</div>
            @endif
            @if (session('delete'))
                <div class="alert alert-danger">{{ session('delete') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger" role="alert">
                    {!! implode('', $errors->all('<li>:message</li>')) !!}
                </div>
            @endif
            <!-- Website Analytics -->
        </div>
    </div>
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-12">
                            <h3 class="fw-bold">Informasi Terbaru</h3>
                            @foreach ($dataInformasi as $info)
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ $info->judul }}</h5>
                                        <p class="card-text">{{ Str::limit($info->deskripsi, 100) }}</p>

                                        @php
                                            $filePath = $info->file;
                                            $extension = pathinfo($filePath, PATHINFO_EXTENSION);
                                        @endphp

                                        @if (in_array($extension, ['pdf', 'jpg', 'jpeg', 'png']))
                                            <!-- Handle PDF and image files -->
                                            @if ($extension === 'pdf')
                                                <iframe src="{{ asset('storage/' . $filePath) }}" width="100%"
                                                    height="400"></iframe>
                                            @else
                                                <img src="{{ asset('storage/' . $filePath) }}" alt="">
                                            @endif
                                        @else
                                            <!-- Fallback to text display -->
                                            <span>{{ $info->file }}</span>
                                        @endif

                                        <p style="font-size: 8pt">
                                            {{ date('d-m-Y', strtotime($info->created_at)) }}
                                            &raquo;
                                            By Admin
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--/ Content -->
@endsection
