@extends('layouts.app')
@section('content')
    <!-- Content -->
    <!-- Count -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            @if (session('warning'))
                <div class="alert alert-warning">{{ session('warning') }}</div>
            @endif
            @if (session('delete'))
                <div class="alert alert-danger">{{ session('delete') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger" role="alert">
                    {!! implode('', $errors->all('<li>:message</li>')) !!}
                </div>
            @endif
            <!-- Website Analytics -->
        </div>
    </div>
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-6 align-self-center">
                            <div class="left-content header-text wow fadeInLeft" data-wow-duration="1s" data-wow-delay="1s">
                                <h6>Selamat Datang </h6>
                                <div class="d-grid gap-2">
                                    <a href="{{ url('main/absensi/create') }}" class="btn btn-primary">
                                        <i class="fas fa-spinner"></i> Absensi
                                    </a>
                                    <a href="{{ url('main/absensi/izin') }}" class="btn btn-danger">
                                        <i class="fas fa-exclamation-triangle"></i> Izin Kerja
                                    </a>
                                    <a href="{{ url('main/kinerja/create') }}" class="btn btn-warning">
                                        <i class="fas fa-poll"></i> Input Aktivitas Kerja
                                    </a>
                                    <a href="{{ url('main/profile') }}" class="btn btn-info">
                                        <i class="fas fa-user"></i> Profile
                                    </a>
                                </div>
                            </div>

                        </div>
                        <div class="col-lg-6">
                            <h3 class="fw-bold">Informasi Terbaru</h3>
                            @foreach ($dataInformasi as $info)
                                <div class="card mb-3">
                                    <div class="card-body">
                                        <h5 class="card-title">{{ $info->judul }}</h5>
                                        <p class="card-text">{{ Str::limit($info->deskripsi, 100) }}</p>
                                        <a href="{{ route('home.detailinfo', $info->id) }}" class="btn btn-warning btn-sm">
                                            Baca Selengkapnya
                                        </a>
                                        <p style="font-size: 8pt">
                                            {{ date('d-m-Y', strtotime($info->created_at)) }}
                                            &raquo;
                                            By Admin
                                        </p>
                                    </div>
                                </div>
                            @endforeach
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--/ Content -->
@endsection
