@extends('layouts.app')

@section('content')
    <div class="main-banner" style="top: -100px;" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <h2 class="mb-4">{{ $title }}</h2>

                <!-- FullCalendar -->
                <div id="calendar"></div>

                <div class="d-grid gap-2 mt-3">
                    <p><a href="{{ url('/') }}" class="btn btn-danger">Kembali</a></p>
                </div>
                <!-- Modal Form -->
                <div class="modal fade" id="kinerjaModal" tabindex="-1" aria-labelledby="modalTitle" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="modalTitle">Tambah Aktivitas Kerja</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <form id="formKinerja" action="{{ route('kinerja.store') }}" method="POST"
                                    enctype="multipart/form-data">
                                    @csrf
                                    <input type="hidden" name="tanggal" id="tanggal">

                                    <div class="mb-3">
                                        <label for="jam_mulai" class="form-label">Jam Mulai*</label>
                                        <input type="time" class="form-control" name="jam_mulai" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="jam_selesai" class="form-label">Jam Selesai*</label>
                                        <input type="time" class="form-control" name="jam_selesai" required>
                                    </div>

                                    <div class="mb-3">
                                        <label for="jenis_kerja_id" class="form-label">Jenis Kerja*</label>
                                        <select class="form-control" name="jenis_kerja_id" required>
                                            <option value="">-- Pilih Jenis Kerja --</option>
                                            @foreach ($dataJenisKerja as $jenis)
                                                <option value="{{ $jenis->id }}">{{ $jenis->uraian }}</option>
                                            @endforeach
                                        </select>
                                    </div>

                                    <div class="mb-3">
                                        <label for="aktivitas_lain" class="form-label">Aktivitas Lain</label>
                                        <textarea class="form-control" name="aktivitas_lain"></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label for="keterangan" class="form-label">Keterangan</label>
                                        <textarea class="form-control" name="keterangan"></textarea>
                                    </div>

                                    <div class="mb-3">
                                        <label for="bukti_foto" class="form-label">Bukti Foto*</label>
                                        <input type="file" class="form-control" name="bukti_foto" accept="image/*"
                                            capture="environment" required>
                                    </div>

                                    <input type="hidden" name="latitude" id="lat">
                                    <input type="hidden" name="longitude" id="long">
                                    <div class="d-grid gap-2 mt-3">
                                        <button type="submit" class="btn btn-primary">Submit</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    {{-- baru  --}}
    <!-- FullCalendar JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');

            // Ambil data kinerja dari Laravel sebagai JSON
            var kinerjaEvents = @json($dataKinerja);

            // Ubah format data agar sesuai dengan event FullCalendar
            var events = kinerjaEvents.map(function(item) {
                return {
                    title: '✔ Aktivitas Terisi ', // Tanda bahwa kinerja sudah diisi
                    start: item.tanggal, // Format: YYYY-MM-DD
                    backgroundColor: '#28a745', // Warna hijau
                    borderColor: '#1e7e34',
                    textColor: '#ffffff'
                };
            });

            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'id', // Bahasa Indonesia
                selectable: true,
                height: 'auto', // Tinggi otomatis mengikuti konten
                contentHeight: 'auto', // Sesuaikan tinggi kalender
                dateClick: function(info) {
                    document.getElementById('tanggal').value = info.dateStr;
                    var modal = new bootstrap.Modal(document.getElementById('kinerjaModal'));
                    modal.show();
                },
                events: events // Tambahkan event kinerja yang sudah ada
            });

            calendar.render();
        });
    </script>
@endsection
@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', (event) => {
            if (navigator.geolocation) {
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        const lat = position.coords.latitude;
                        const long = position.coords.longitude;

                        // Update hidden inputs
                        document.getElementById('lat').value = lat;
                        document.getElementById('long').value = long;

                        // Update location text input
                        document.getElementById('location').value = `${lat}, ${long}`;

                        // Update map iframe
                        const mapUrl = `https://maps.google.com/maps?q=${lat},${long}&z=15&output=embed`;
                        document.getElementById('map').src = mapUrl;
                    },
                    function(error) {
                        console.error('Error occurred. Error code: ' + error.code);
                        alert('Gagal mendapatkan lokasi. Pastikan lokasi diaktifkan dan izinkan akses.');
                    }, {
                        enableHighAccuracy: true,
                        timeout: 5000,
                        maximumAge: 0
                    }
                );
            } else {
                alert('Geolocation tidak didukung oleh browser ini.');
            }
        });
    </script>
@endpush


{{-- lama  --}}
{{-- <!-- FullCalendar JS -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.css">
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@5.11.3/main.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            var calendarEl = document.getElementById('calendar');
            var calendar = new FullCalendar.Calendar(calendarEl, {
                initialView: 'dayGridMonth',
                locale: 'id', // Bahasa Indonesia
                selectable: true,
                dateClick: function(info) {
                    document.getElementById('tanggal').value = info.dateStr;
                    var modal = new bootstrap.Modal(document.getElementById('kinerjaModal'));
                    modal.show();
                }
            });
            calendar.render();
        });
    </script> --}}
