@extends('layouts.app')
@section('content')
    <!-- Content -->
    <!-- Count -->
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">

            @if (session('success'))
                <div class="alert alert-success">{{ session('success') }}</div>
            @endif
            @if (session('warning'))
                <div class="alert alert-warning">{{ session('warning') }}</div>
            @endif
            @if (session('delete'))
                <div class="alert alert-danger">{{ session('delete') }}</div>
            @endif
            @if ($errors->any())
                <div class="alert alert-danger" role="alert">
                    {!! implode('', $errors->all('<li>:message</li>')) !!}
                </div>
            @endif
            <!-- Website Analytics -->
        </div>
    </div>
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="row">
                        <div class="col-lg-12">
                            <h3 class="fw-bold mb-3">{{ $title }} </h3>
                            <div class="card mb-3">
                                <div class="card-body">
                                    <h3>{{ $dataUser->name }}</h3>
                                </div>
                            </div>

                            {{-- FILTER DETAIL REKAP --}}
                            <div class="card mb-3">
                                <div class="card-body">
                                    <form method="GET" action="{{ route('kinerja.index') }}">
                                        <div class="row">
                                            <div class="col-lg-5">
                                                <label for="bulan">Bulan</label>
                                                <select name="bulan" id="bulan" class="form-control">
                                                    @foreach (range(1, 12) as $month)
                                                        <option value="{{ $month }}"
                                                            {{ $selectedMonth == $month ? 'selected' : '' }}>
                                                            {{ DateTime::createFromFormat('!m', $month)->format('F') }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-5">
                                                <label for="tahun">Tahun</label>
                                                <select name="tahun" id="tahun" class="form-control">
                                                    @foreach (range(date('Y') - 5, date('Y')) as $year)
                                                        <option value="{{ $year }}"
                                                            {{ $selectedYear == $year ? 'selected' : '' }}>
                                                            {{ $year }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="col-lg-2 d-flex align-items-end">
                                                <button type="submit" class="btn btn-primary w-100">Filter</button>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                            {{-- FILTER DETAIL REKAP --}}


                            {{-- inputan aktivitas  --}}
                            <div class="card mb-3">
                                <div class="card-body">
                                    <p><i class="fa fa-calendar"></i>&nbsp; Inputan Aktivitas
                                        ({{ DateTime::createFromFormat('!m', $selectedMonth)->format('F') }} -
                                        {{ $selectedYear }})
                                    </p>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="">
                                                <tr class="text-center bg-info text-dark">
                                                    <th rowspan="2" colspan="2" style="vertical-align: middle;">
                                                        Aktivitas Input</th>
                                                    <th rowspan="2" colspan="2" style="vertical-align: middle;">
                                                        Aktivitas Belum Divalidasi</th>
                                                    <th colspan="4" style="vertical-align: middle;">Aktivitas Sudah
                                                        Divalidasi</th>
                                                </tr>
                                                <tr class="text-center bg-info text-dark">
                                                    <th colspan="2">Aktivitas Disetujui</th>
                                                    <th colspan="2">Aktivitas Ditolak</th>
                                                </tr>
                                                <tr>
                                                    <th>Jumlah Aktivitas</th>
                                                    <th>Jumlah Menit</th>
                                                    <th>Jumlah Aktivitas</th>
                                                    <th>Jumlah Menit</th>
                                                    <th>Jumlah Aktivitas</th>
                                                    <th>Jumlah Menit</th>
                                                    <th>Jumlah Aktivitas</th>
                                                    <th>Jumlah Menit</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <tr class="text-center">
                                                    <td>{{ $totalInput }}</td>
                                                    <td>{{ $totalMenitInput }}</td>
                                                    <td>{{ $pending }}</td>
                                                    <td>{{ $totalMenitPending }}</td>
                                                    <td>{{ $disetujui }}</td>
                                                    <td>{{ $totalMenitDisetujui }}</td>
                                                    <td>{{ $ditolak }}</td>
                                                    <td>{{ $totalMenitditolak }}</td>
                                                </tr>
                                            </tbody>



                                        </table>

                                    </div>
                                </div>
                            </div>
                            {{-- inputan aktivitas  --}}

                            {{-- Detail Rekap Absensi --}}
                            <div class="card mb-3">
                                <div class="card-body">
                                    <p><i class="fa fa-calendar"></i>&nbsp; Detail Rekap Absensi
                                        ({{ DateTime::createFromFormat('!m', $selectedMonth)->format('F') }} -
                                        {{ $selectedYear }})
                                    </p>
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead class="bg-info text-dark">
                                                <tr>
                                                    <th>Jenis Absensi</th>
                                                    <th>Uraian Jenis Absensi</th>
                                                    <th>Jumlah Hari</th>
                                                    <th>Input Aktivitas</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach ($rekapAbsensi as $jenis)
                                                    @php $rowspan = $jenis->uraianJenisAbsensi->count(); @endphp
                                                    @if ($rowspan > 0)
                                                        <tr>
                                                            <td rowspan="{{ $rowspan }}">{{ $jenis->nama }}</td>
                                                            <td>{{ $jenis->uraianJenisAbsensi[0]->nama }}</td>
                                                            <td>{{ $jenis->uraianJenisAbsensi[0]->absensi->count() }}
                                                            </td>
                                                            <td>dilarang input</td>
                                                        </tr>
                                                        @for ($i = 1; $i < $rowspan; $i++)
                                                            <tr>
                                                                <td>{{ $jenis->uraianJenisAbsensi[$i]->nama }}</td>
                                                                <td>{{ $jenis->uraianJenisAbsensi[$i]->absensi->count() }}

                                                                </td>
                                                                <td>dilarang input</td>
                                                            </tr>
                                                        @endfor
                                                    @endif
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            {{-- Detail Rekap Absensi --}}


                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>

    <!--/ Content -->
@endsection
