@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}
                        <h1 style="text-align: center">{{ $title }}</h1>
                        <p style="text-align: center">Nilai yang Nyata</p>

                        <form action="{{ route('kuis.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                @foreach ($pertanyaan as $item)
                                    <div class="row mb-3">
                                        <div class="col-lg-6">
                                            <label>Pertanyaan</label>
                                            <input type="text" value="{{ $item->pertanyaan }}" class="form-control"
                                                readonly disabled>
                                        </div>
                                        <div class="col-lg-6">
                                            <label>Pilihan*</label>
                                            <select name="jenis_kuis[]" class="form-control" required>
                                                <option value="Sangat Baik">Sangat Baik</option>
                                                <option value="Cepat">Cepat</option>
                                                <option value="Baik">Baik</option>
                                                <option value="Cukup">Cukup</option>
                                                <option value="Buruk">Buruk</option>
                                            </select>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                            <!-- /.card-body -->

                            <div class="col-lg-12 mb-3">
                                <input type="hidden" name="masyarakat_id" value="{{ Auth::id() }}" class="form-control"
                                    required>
                                <button type="submit" class="btn btn-primary btn-block">Submit</button>
                            </div>
                        </form>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
