@extends('layouts.app')
@section('content')
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <h1 style="text-align: center">{{ $title }}</h1>
                <p style="text-align: center">Nilai yang Nyata</p>
                <div class="row">
                    <div class="col-md-12">
                        <div class="table-responsive">
                            <table id="dataTable" class="table border-top">
                                <thead>
                                    <tr>
                                        <th>No</th>
                                        <th>Nama Masyarakat</th>
                                        <th>Pertanyaan</th>
                                        <th>Jawaban</th>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    @php
                                        $urutan = 1;
                                    @endphp
                                    @foreach ($dataJawaban as $item)
                                        <tr>
                                            <td>{{ $urutan++ }}</td>
                                            <td>{{ $item->masyarakat->nama_masyarakat }}</td>
                                            <td>{{ $item->quis->pertanyaan }}</td>
                                            <td>{{ $item->jawaban }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
