@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}
                        <h1 style="text-align: center">Buat Pengaduan Anda</h1>
                        <p style="text-align: center">Lampirkan Bukti Nyata</p>

                        <form action="{{ route('pengaduan.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">
                                <div class="form-group mb-3">
                                    <label>Jenis Pengaduan*</label>
                                    <select name="jenis_pengaduan" class="form-control" required>
                                        <option value="">Pilih</option>
                                        <option value="Penyelundupan barang">Penyelundupan barang</option>
                                        <option value="Illegal fishing">Illegal fishing</option>
                                        <option value="Pembajakan kapal">Pembajakan kapal</option>
                                        <option value="Pencurian di perairan">Pencurian di perairan</option>
                                        <option value="Pencemaran lingkungan perairan">Pencemaran lingkungan perairan
                                        </option>
                                        <option value="Kecelakaan laut">Kecelakaan laut</option>
                                        <option value="Penangkapan ikan dengan bahan peledak">Penangkapan ikan dengan bahan
                                            peledak</option>
                                        <option value="Penyanderaan atau perompakan">Penyanderaan atau perompakan</option>
                                        <option value="Kegiatan perikanan tanpa izin">Kegiatan perikanan tanpa izin</option>
                                        <option value="Kegiatan kapal asing tanpa izin">Kegiatan kapal asing tanpa izin
                                        </option>
                                    </select>
                                </div>

                                <div class="form-group mb-3">
                                    <label>Deskripsi*</label>
                                    <textarea name="deskripsi" id="deskripsi" cols="20" rows="5" class="form-control"></textarea>
                                </div>

                                <div class="form-group mb-3">
                                    <label>Tanggal Pengaduan*</label>
                                    <input type="date" name="tgl_pengaduan" class="form-control"
                                        placeholder="Tanggal Pengaduan" required>
                                </div>

                                <div class="form-group mb-3">
                                    <label>Bukti Pengaduan*</label>
                                    <input type="file" name="foto_pengaduan" class="form-control"
                                        placeholder="Bukti Pengaduan" required>
                                </div>
                            </div>
                            <!-- /.card-body -->

                            <div class="col-lg-12 form-group mb-3">
                                <input type="hidden" name="status_pengaduan" value="Pending" class="form-control" required>
                                <input type="hidden" name="id_masyarakat" value="{{ Auth::id() }}" class="form-control"
                                    required>
                                <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                <a href="{{ url('main/pengaduan') }}" class="btn btn-danger">Kembali</a>
                            </div>
                        </form>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
