@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="container-fluid" style="padding-left: 1%;">
                    <a href="{{ url('main/pengaduan/create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> Buat Pengaduan
                    </a>
                    <a href="{{ url('main/darurat/create') }}" class="btn btn-danger">
                        <i class="fas fa-exclamation-triangle"></i> Tanggap Darurat
                    </a>
                </div>
                <br>
                <br>
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}

                        <div class="table-responsive">
                            <table id="dataTable" class="table border-top">
                                <thead>
                                    <tr>
                                    <tr>
                                        <th>No</th>
                                        <th>Si Pengadu</th>
                                        <th>Jenis Pengaduan</th>
                                        <th>Tanggal Kejadian</th>
                                        <th>Deskripsi </th>
                                        <th>Bukti </th>
                                        <th>Status </th>
                                        <th>Keterangan </th>
                                        <th>Waktu Update Terakhir </th>
                                        <th>Aksi</th>
                                    </tr>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    @php
                                        $urutan = 1;
                                    @endphp
                                    @foreach ($dataPengaduan as $item)
                                        <tr>
                                            <td>{{ $urutan++ }}</td>
                                            <td>{{ $item->masyarakat->nama_masyarakat }}</td>
                                            <td>{{ $item->jenis_pengaduan }}</td>
                                            <td>{{ date('l / d-m-Y', strtotime($item->tgl_pengaduan)) }}</td>
                                            <td>{!! Str::limit(strip_tags($item->deskripsi), 45) !!}</td>
                                            <td>
                                                <a target="_blank" href="{{ asset('storage/' . $item->foto_pengaduan) }}">
                                                    <img style="width: 100px" class="img-thumbnail"
                                                        src="{{ asset('storage/' . $item->foto_pengaduan) }}"
                                                        alt="">
                                                </a>
                                            </td>
                                            <td>
                                                @if ($item->status_pengaduan == 'Tidak Terjangkau')
                                                    <span class="btn btn-danger">{{ $item->status_pengaduan }}</span>
                                                @elseif ($item->status_pengaduan == 'Sedang Diproses')
                                                    <span class="btn btn-primary">{{ $item->status_pengaduan }}</span>
                                                @elseif ($item->status_pengaduan == 'Terselesaikan')
                                                    <span class="btn btn-success">{{ $item->status_pengaduan }}</span>
                                                @elseif ($item->status_pengaduan == 'Pending')
                                                    <span class="btn btn-warning">{{ $item->status_pengaduan }}</span>
                                                @else
                                                    <span>{{ $item->status_pengaduan }}</span>
                                                @endif
                                            </td>
                                            <td>{{ $item->keterangan }}</td>
                                            <td>{{ date('l / d-m-Y H:i', strtotime($item->updated_at)) }}</td>
                                            <td>
                                                @if ($item->status_pengaduan == 'Pending')
                                                    <form action="{{ route('pengaduan.destroy', $item->id) }}"
                                                        method="POST" class="d-inline">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="submit" class="btn btn-danger border-0"
                                                            onclick="return confirm('Are you sure?'); return false;"><i
                                                                class="fa fa-trash"></i></button>
                                                    </form>
                                                @else
                                                    <a href="#" class="btn btn-danger">
                                                        <i class="fa fa-calendar"></i>
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach

                                    <!-- Tambahkan lebih banyak baris dengan contoh data sesuai kebutuhan -->
                                </tbody>
                            </table>
                        </div>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
