@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}
                        <h1 style="text-align: center">Buat Permohonan Anda</h1>
                        <p style="text-align: center">Lampirkan Bukti Nyata</p>

                        <form action="{{ route('perizinan.store') }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="card-body">

                                <div class="form-group mb-3">
                                    <label>Tentang*</label>
                                    <input type="text" name="nama" class="form-control" placeholder="Tentang"
                                        required>
                                </div>
                                <div class="form-group mb-3">
                                    <label>No Handphone*</label>
                                    <input type="number" name="no_telp" class="form-control" placeholder="No Handphone"
                                        required>
                                </div>
                                <div class="form-group mb-3">
                                    <label>Tujuan Kegiatan*</label>
                                    <textarea name="tujuan_kegiatan" id="tujuan_kegiatan" cols="20" rows="5" class="form-control" required></textarea>
                                </div>
                                <div class="form-group mb-3">
                                    <label>Waktu Kegiatan*</label>
                                    <input type="date" name="waktu_kegiatan" class="form-control"
                                        placeholder="Waktu Kegiatan" required>
                                </div>
                                <div class="form-group mb-3">
                                    <label>Tempat Kegiatan*</label>
                                    <input type="text" name="tempat_kegiatan" class="form-control"
                                        placeholder="Tempat Kegiatan" required>
                                </div>
                            </div>
                            <!-- /.card-body -->

                            <div class="col-lg-12 form-group mb-3">
                                <input type="hidden" name="status_perizinan" value="Pending" class="form-control" required>
                                <input type="hidden" name="id_masyarakat" value="{{ Auth::id() }}" class="form-control"
                                    required>
                                <button type="submit" class="btn btn-primary btn-block">Submit</button>
                                <a href="{{ url('main/pengaduan') }}" class="btn btn-danger">Kembali</a>
                            </div>
                        </form>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
