@extends('layouts.app')
@section('content')
    <!-- Content -->
    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">
                <div class="container-fluid" style="padding-left: 1%;">
                    <a href="{{ url('main/perizinan/create') }}" class="btn btn-primary">Buat Permohonan Perizinan</a>
                </div>
                <br>
                <br>
                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if (session('warning'))
                    <div class="alert alert-warning">{{ session('warning') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}

                        <div class="table-responsive">
                            <table id="dataTable" class="table border-top">
                                <thead>
                                    <tr>
                                    <tr>
                                        <th>No</th>
                                        <th>Pemohon</th>
                                        <th>Tentang</th>
                                        <th>No Telpon</th>
                                        <th>Tujuan Kegiatan</th>
                                        <th>Tempat Kegiatan</th>
                                        <th>Waktu Kegiatan</th>
                                        <th>Status Permohonan</th>
                                        <th>Aksi</th>
                                    </tr>
                                    </tr>
                                </thead>
                                <tbody class="table-border-bottom-0">
                                    @php
                                        $urutan = 1;
                                    @endphp
                                    @foreach ($dataPerizinan as $item)
                                        <tr>
                                            <td>{{ $urutan++ }}</td>
                                            <td>{{ $item->masyarakat->nama_masyarakat }}</td>
                                            <td>{{ $item->nama }}</td>
                                            <td>{{ $item->no_telp }}</td>
                                            <td>{{ $item->tujuan_kegiatan }}</td>
                                            <td>{{ $item->tempat_kegiatan }}</td>
                                            <td>{{ date('l / d-m-Y', strtotime($item->waktu_kegiatan)) }}</td>
                                            <td>
                                                @if ($item->status_perizinan == 'Ditolak')
                                                    <span class="btn btn-danger">{{ $item->status_perizinan }}</span>
                                                @elseif ($item->status_perizinan == 'Diproses')
                                                    <span class="btn btn-primary">{{ $item->status_perizinan }}</span>
                                                @elseif ($item->status_perizinan == 'Disetujui')
                                                    <span class="btn btn-success">{{ $item->status_perizinan }}</span>
                                                @elseif ($item->status_perizinan == 'Pending')
                                                    <span class="btn btn-warning">{{ $item->status_perizinan }}</span>
                                                @else
                                                    <span>{{ $item->status_perizinan }}</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if ($item->status_perizinan == 'Pending')
                                                    <form action="{{ route('perizinan.destroy', $item->id) }}"
                                                        method="POST" class="d-inline">
                                                        @csrf
                                                        @method('delete')
                                                        <button type="submit" class="btn btn-danger border-0"
                                                            onclick="return confirm('Are you sure?'); return false;"><i
                                                                class="fa fa-trash"></i></button>
                                                    </form>
                                                @else
                                                    <a href="#" class="btn btn-warning">
                                                        <i class="fa fa-calendar"></i>
                                                    </a>
                                                @endif
                                            </td>
                                        </tr>
                                    @endforeach

                                    <!-- Tambahkan lebih banyak baris dengan contoh data sesuai kebutuhan -->
                                </tbody>
                            </table>
                        </div>
                        {{-- isi  --}}
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--/ Content -->
@endsection
