@extends('layouts.app')
@section('content')
    <!-- Content -->

    <div class="main-banner wow fadeIn" id="top" data-wow-duration="1s" data-wow-delay="0.5s">
        <div class="container">
            <div class="row">

                @if (session('success'))
                    <div class="alert alert-success">{{ session('success') }}</div>
                @endif
                @if (session('delete'))
                    <div class="alert alert-danger">{{ session('delete') }}</div>
                @endif
                @if ($errors->any())
                    <div class="alert alert-danger" role="alert">
                        {!! implode('', $errors->all('<li>:message</li>')) !!}
                    </div>
                @endif

                <!-- Account -->

                <div class="row">
                    <div class="col-md-12">
                        {{-- isi  --}}

                        {{-- isi  --}}
                        <h1 style="text-align: center">Profile Anda</h1>
                        <p style="text-align: center">Ubah Profile </p>
                        <hr>
                        <form action="{{ route('profile.update', $dataUser->id) }}" method="POST"
                            enctype="multipart/form-data">
                            @method('put')
                            @csrf
                            <div class="row">
                                <!-- Nama Lengkap -->
                                <div class="mb-3 col-md-6">
                                    <label for="user_id" class="form-label">Nama Lengkap Anda</label>
                                    <input class="form-control" type="text" value="{{ $dataUser->name }}" disabled />
                                    <input type="hidden" id="user_id" name="user_id" value="{{ $dataUser->id }}" />
                                </div>

                                <!-- Jenis Kelamin -->
                                <div class="mb-3 col-md-6">
                                    <label for="jk">Jenis Kelamin</label>
                                    <select name="jk" id="jk" class="form-control" required>
                                        <option value="Laki-laki"
                                            {{ old('jk', optional($dataBio)->jk) == 'Laki-laki' ? 'selected' : '' }}>
                                            Laki-laki</option>
                                        <option value="Perempuan"
                                            {{ old('jk', optional($dataBio)->jk) == 'Perempuan' ? 'selected' : '' }}>
                                            Perempuan</option>
                                    </select>

                                </div>

                                <!--  Tanggal Lahir -->
                                <div class="mb-3 col-md-6">
                                    <label for="ttl" class="form-label">Tanggal Lahir</label>
                                    <input type="date" name="ttl" id="ttl" class="form-control"
                                        value="{{ old('ttl', optional($dataBio)->ttl ?? '') }}" placeholder=" Tanggal Lahir"
                                        required />

                                </div>

                                <!-- NIK -->
                                <div class="mb-3 col-md-6">
                                    <label for="nik" class="form-label">NIK</label>
                                    <input type="text" name="nik" id="nik" class="form-control"
                                        value="{{ old('nik', optional($dataBio)->nik ?? '') }}"
                                        placeholder="Nomor Induk Kependudukan" required />

                                </div>

                                <!-- Alamat -->
                                <div class="mb-3 col-md-12">
                                    <label for="alamat" class="form-label">Alamat</label>
                                    <textarea name="alamat" id="alamat" class="form-control" rows="3" required>{{ old('alamat', optional($dataBio)->alamat ?? '') }}</textarea>

                                </div>

                                <!-- No HP -->
                                <div class="mb-3 col-md-6">
                                    <label for="no_hp" class="form-label">No HP</label>
                                    <input type="text" name="no_hp" id="no_hp" class="form-control"
                                        value="{{ old('no_hp', optional($dataBio)->no_hp ?? '') }}"
                                        placeholder="08xxxxxxxxxx" required />

                                </div>

                                <!-- NPWP -->
                                <div class="mb-3 col-md-6">
                                    <label for="npwp" class="form-label">NPWP</label>
                                    <input type="text" name="npwp" id="npwp" class="form-control"
                                        value="{{ old('npwp', optional($dataBio)->npwp ?? '') }}"
                                        placeholder="Nomor NPWP" />

                                </div>

                                <!-- No Kontrak -->
                                <div class="mb-3 col-md-6">
                                    <label for="no_kontrak" class="form-label">No Kontrak</label>
                                    <input type="text" name="no_kontrak" id="no_kontrak" class="form-control"
                                        value="{{ old('no_kontrak', optional($dataBio)->no_kontrak ?? '') }}"
                                        placeholder="Nomor Kontrak" />

                                </div>

                                <!-- Sertifikasi -->
                                <div class="mb-3 col-md-6">
                                    <label for="sertifikasi" class="form-label">Sertifikasi</label>
                                    <input type="text" name="sertifikasi" id="sertifikasi" class="form-control"
                                        value="{{ old('sertifikasi', optional($dataBio)->sertifikasi ?? '') }}"
                                        placeholder="Sertifikasi yang dimiliki" />
                                </div>

                                <!-- Tombol -->
                                <div class="d-grid gap-2 mt-3">
                                    <button type="submit" class="btn btn-primary ">Simpan Perubahan</button>
                                    <a href="{{ url('main/home') }}" class="btn btn-danger">Kembali</a>
                                    <button type="reset" class="btn btn-secondary">Reset</button>
                                </div>
                            </div>
                        </form>

                    </div>
                    {{-- isi  --}}
                    {{-- reset password  --}}
                    <br>
                    <br>
                    <div class="col-md-12 mt-3">
                        {{-- isi  --}}

                        {{-- isi  --}}
                        <h1 style="text-align: center">Akun Anda</h1>
                        <p style="text-align: center">Ubah Akun </p>
                        <hr>
                        <form action="{{ route('profile.reset', $dataUser->id) }}" method="POST"
                            enctype="multipart/form-data">
                            {{-- @method('put') --}}
                            @csrf
                            <div class="row">
                                <!-- Nama Lengkap -->
                                <div class="mb-3 col-md-6">
                                    <label for="user_id" class="form-label">Nama Lengkap Anda</label>
                                    <input class="form-control" type="text" value="{{ $dataUser->name }}" disabled />
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label for="username" class="form-label">Username</label>
                                    <input class="form-control" type="text" id="username"
                                        value="{{ $dataUser->username }}" disabled />
                                </div>
                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Password Baru</label>
                                    <input type="password" name="new_password" class="form-control"
                                        placeholder="*********">
                                </div>

                                <div class="mb-3 col-md-6">
                                    <label class="form-label">Konfirmasi Password Baru</label>
                                    <input type="password" name="confirm_password" class="form-control"
                                        placeholder="********">
                                </div>


                                <!-- Tombol -->
                                <div class="d-grid gap-2 mt-3">
                                    <button type="submit" class="btn btn-primary ">Simpan Perubahan</button>
                                    <a href="{{ url('main/home') }}" class="btn btn-danger">Kembali</a>
                                    <button type="reset" class="btn btn-secondary">Reset</button>
                                </div>
                            </div>
                        </form>

                    </div>
                    {{-- reset password  --}}

                </div>
            </div>
        </div>
    </div>
@endsection
