<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\AbsensiController;
use App\Http\Controllers\KinerjaController;
use App\Http\Controllers\Main\HomeController;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Main\ProfileController;
use App\Http\Controllers\Auth\RegisterController;

// Route::get('/', function () {
//     return view('welcome');
// });
Route::get('/linkstorage', function () {
    Artisan::call('storage:link');
});

// Route::redirect('/', '/main/home');
Route::redirect('/', '/auth/login');
Route::prefix('auth')->middleware('guest')->group(function () {
    Route::get('/login', [LoginController::class, 'index'])->name('login');
    Route::post('/login', [LoginController::class, 'processLogin'])->name('login.process');
    // Route::resource('register', RegisterController::class);
});
Route::get('logout', [LoginController::class, 'logout'])->name('logout');

Route::prefix('main')->middleware('auth')->group(function () {
    Route::get('home', [HomeController::class, 'index'])->name('home');
    Route::get('home/detailinfo/{id}', [HomeController::class, 'detailinfo'])->name('home.detailinfo');
    // Route::resource('home', HomeController::class);
    Route::post('profile/reset/{id}', [ProfileController::class, 'reset'])->name('profile.reset');
    Route::resource('profile', ProfileController::class);
    Route::get('absensi/izin', [AbsensiController::class, 'izin'])->name('absensi.izin');
    Route::resource('absensi', AbsensiController::class);
    Route::resource('kinerja', KinerjaController::class);
    // Route::resource('pengaduan', PengaduanController::class);
    // Route::resource('perizinan', PerizinanController::class);
    // Route::resource('darurat', DaruratController::class);
    // Route::resource('kuis', KuisionerController::class);
});
