<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Data Kinerja Pegawai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        img {
            max-width: 70px;
            height: auto;
        }

        .container {
            width: 100%;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            margin: 0;
            padding: 0;
            font-size: 16px;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>Data Kinerja Pegawai</h2>
        <h3>Periode: <?php echo e($judulPeriode); ?></h3>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Shift</th>
                <th>Jenis Absen</th>
                <th>Uraian Absensi</th>
                <th>Jam Datan</th>
                <th>Lokasi Datang</th>
                <th>Jam Pulang</th>
                <th>Lokasi Pulang</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($item['user']['name'] ?? '-'); ?></td>
                    <td><?php echo e($item['shift']['nama'] ?? '-'); ?></td>
                    <td><?php echo e($item['jenis']['nama'] ?? '-'); ?></td>
                    <td><?php echo e($item['uraian']['nama'] ?? '-'); ?></td>
                    <td><?php echo e(date('d-m-Y', strtotime($item['jam_datang']))); ?></td>
                    <td><?php echo e($item['lokasi_datang'] ?? '-'); ?></td>
                    <td><?php echo e(date('d-m-Y', strtotime($item['jam_pulang']))); ?></td>
                    <td><?php echo e($item['lokasi_pulang'] ?? '-'); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\laragon\www\kinerja-pegawai-laravel\resources\views/exports/absensi.blade.php ENDPATH**/ ?>