<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Data Kinerja Pegawai</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 10px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 5px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        img {
            max-width: 70px;
            height: auto;
        }

        .container {
            width: 100%;
            text-align: center;
            margin-bottom: 10px;
        }

        h2 {
            margin: 0;
            padding: 0;
            font-size: 16px;
        }
    </style>
</head>

<body>
    <div class="container">
        <h2>Data Kinerja Pegawai</h2>
        <h3>Periode: <?php echo e($judulPeriode); ?></h3>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Nama</th>
                <th>Jabatan</th>
                <th>Tanggal</th>
                <th>Jam Mulai</th>
                <th>Jam Selesai</th>
                <th>Aktivitas Kerja</th>
                <th>Aktivitas Lain</th>
                <th>Keterangan</th>
                <th>Bukti Foto</th>
                <th>Validator</th>
                <th>Status Validasi</th>
                <th>Keterangan Validasi</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($item['user']['name'] ?? '-'); ?></td>
                    <td><?php echo e($item['user']['bidang']['nama'] ?? '-'); ?></td>
                    <td><?php echo e(date('d-m-Y', strtotime($item['tanggal']))); ?></td>
                    <td><?php echo e($item['jam_mulai']); ?></td>
                    <td><?php echo e($item['jam_selesai']); ?></td>
                    <td><?php echo e($item['jenis']['uraian'] ?? '-'); ?></td>
                    <td><?php echo e($item['aktivitas_lain']); ?></td>
                    <td><?php echo e($item['keterangan']); ?></td>
                    <td>
                        <?php if($item['bukti_foto']): ?>
                            <img src="<?php echo e(public_path('storage/' . $item['bukti_foto'])); ?>">
                        <?php else: ?>
                            -
                        <?php endif; ?>
                    </td>
                    <td><?php echo e($item['validator']['name'] ?? '-'); ?></td>
                    <td><?php echo e($item['status_validasi']); ?></td>
                    <td><?php echo e($item['keterangan_validasi']); ?></td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\laragon\www\kinerja-pegawai-laravel\resources\views/exports/kinerja.blade.php ENDPATH**/ ?>